<?php
/*	This work is licensed under Creative Commons GNU LGPL License.

	License: http://creativecommons.org/licenses/LGPL/2.1/

   Version: 0.9

	Author:  Stefan Goessner/2006
	Web:     http://goessner.net/ 
*/

$bid = "1234567";  // hardwire your blog id ..
function userpass() { return base64_encode("username:password"); }  // your username and password

function escapeJson($str) { return str_replace(array("\\", '"', "\n", "\r"), array("\\\\", '\\"', "\\n", "\\r"), $str); }

if ($_SERVER["REQUEST_METHOD"] == "GET") {
   if (isset($_GET["blogs"])) {
      $res = Blogger::blogs();
      if (!array_key_exists("err", $res))
         print($res["xml"]);
      else
         print($res["err"]);
   }
   else if (isset($_GET["blog"])) { // title of hardwired blog ..
      $res = Blogger::blog($bid);
      if (!array_key_exists("err", $res)) {
         if (preg_match('/<link href="(.*?)" rel="alternate" title="(.*?)" type="text\/html"\/>/', $res["xml"], $matches))
            $json = '{"bid": "'.$bid.'", "uri": "'.$matches[1].'", "title": "'.$matches[2].'", "entries": [';
         if (preg_match_all('/<entry xmlns="http:\/\/purl.org\/atom\/ns#">(.*?)<\/entry>/s', $res["xml"], $entries)) {
            for ($i=0; $i<count($entries[1]); $i++) {
               preg_match('/<link href="https:\/\/www.blogger.com\/atom\/'.$bid.'\/(.*?)" rel="service\.edit" title="(.*?)" type="application\/atom\+xml"\/>/', $entries[1][$i], $matches);
               $json .= ($i==0?'':',').'{ "title": "'.escapeJson($matches[2]).'", "eid": "'.$matches[1].'", ';
               preg_match('/<link href="(.*?)" rel="alternate" title="(.*?)" type="text\/html"\/>/', $entries[1][$i], $matches);
               $json .= '"uri": "'.$matches[1].'", ';
               preg_match('/<issued>(.*?)<\/issued>/', $entries[1][$i], $matches);
               $json .= '"issued": "'.$matches[1].'"}';
            }
         }
         $json .= ']}';
         print($json);
      }
      else
         print($res["err"]);
   }
   else if (isset($_GET["entry"])) {
      $res = Blogger::entry($bid, $_GET["eid"]);
      if (!array_key_exists("err", $res)) {
         if (preg_match('/<title mode="escaped" type="text\/html">(.*?)<\/title>/', $res["xml"], $matches))
            $title = escapeJson($matches[1]);
         if (preg_match('/<content.*?>(?:.*?<div.*?>)+(.*?)(?:<\/div>)+.*?<\/content>/s', $res["xml"], $matches))
            $content = escapeJson($matches[1]);
         if (preg_match('/<issued>(.*?)<\/issued>/', $res["xml"], $matches))
            $issued = $matches[1];
         print('{"eid": "'.$_GET["eid"].'", "title": "'.$title.'", "content": "'.$content.'", "issued": "'.$issued.'"}');
      }
      else
         print($res["err"]);
   }
   else {
      print("ERROR: unknown GET directive ..");
      print_r($_GET);
   }
}
else if ($_SERVER["REQUEST_METHOD"] == "POST") {
   if (isset($_POST["create"])) {
      $res = Blogger::createEntry($bid, get_magic_quotes_gpc() ? stripslashes($_POST["entry"]) : $_POST["entry"]);
      if (!array_key_exists("err", $res)) {
         preg_match('/<link href="https:\/\/www.blogger.com\/atom\/'.$bid.'\/(.*?)" rel="service\.edit" title="(.*?)" type="application\/atom\+xml"\/>/', $res["xml"], $matches);
         $json = '{ "title": "'.escapeJson($matches[2]).'", "eid": "'.$matches[1].'", ';
         preg_match('/<link href="(.*?)" rel="alternate" title="(.*?)" type="text\/html"\/>/', $res["xml"], $matches);
         $json .= '"uri": "'.$matches[1].'", ';
         preg_match('/<issued>(.*?)<\/issued>/', $res["xml"], $matches);
         $json .= '"issued": "'.$matches[1].'"}';
         print($json);
      }
      else
         print($res["err"]);
   }
   else if (isset($_POST["remove"])) {
      $res = Blogger::removeEntry($bid, $_POST["eid"]);
      if (array_key_exists("err", $res))
         print($res["err"]);
   }
   else if (isset($_POST["update"])) {
      $res = Blogger::replaceEntry($bid, $_POST["eid"], get_magic_quotes_gpc() ? stripslashes($_POST["entry"]) : $_POST["entry"]);
      if (array_key_exists("err", $res))
         print($res["err"]);
   }
   else {
      print("unknown POST directive .. ");
      print_r($_POST);
   }
}
else
   print("unhandled Request Method '" . $_SERVER["REQUEST_METHOD"] . "'");


class Blogger {
   function timeout() { return 20; }
   function sendRequest($req, $expectresult) {
      $fp = fsockopen("ssl://www.blogger.com", 443, $errno, $errstr); 
      if ($fp) {
         socket_set_timeout($fp, Blogger::timeout());
         fputs($fp, $req);
         $hdr = fgets($fp);
         if (substr_count($hdr, $expectresult)) {
            while (($line = fgets($fp)) != "\r\n") $hdr .= $line;  // read header info
            if (preg_match("/Transfer\\-Encoding:\\s+chunked\\r\\n/",$hdr)) {
               for ($line = fgets($fp); preg_match("/([0-9a-fA-F]+)/", $line, $matches) && hexdec($matches[1]) > 0; $line = fgets($fp)) {
                  $xml .= fread($fp, hexdec($matches[1]));
                  $line = fgets($fp);  // read empty line (CRLF)
               }
            }
            else if (preg_match('/Content\\-Length:\\s+([0-9]*)\\r\\n/', $hdr, $matches)) {
               $xml = fread($fp, $matches[1]);
            }
            else {
               while (!feof($fp))
                  $xml .= fgets($fp, 4096);
            }
            $res = Array("hdr" => $hdr, "xml" => $xml);
         }
         else
            $res = Array("hdr" => "", "xml" => "", "err" => "ERROR: " . $hdr);
         fclose($fp);
      }
      else
         $res = Array("hdr" => "", "xml" => "", "err" => "ERROR: " . $errno . ": " . $errstr);

      return $res;
   }
   function blogs() {
      $req = "GET /atom HTTP/1.1\r\n"
           . "Host: www.blogger.com\r\n"
           . "Connection: Close\r\n" 
           . "Authorization: Basic " . userpass() . "\r\n\r\n";
      return Blogger::sendRequest($req, "200");
   }
   function blog($bid) {
      $req  = "GET /atom/$bid HTTP/1.1\r\n"
            . "Host: www.blogger.com\r\n"
            . "Connection: Close\r\n" 
            . "Authorization: Basic " . userpass() . "\r\n\r\n";
      return Blogger::sendRequest($req, "200");
   }
   function entry($bid, $eid) {
      $req  = "GET /atom/$bid/$eid HTTP/1.1\r\n"
            . "Host: www.blogger.com\r\n"
            . "Connection: Keep-Alive\r\n" 
            . "Authorization: Basic " . userpass() . "\r\n\r\n";
      return Blogger::sendRequest($req, "200");
   }
   function createEntry($bid, $entry) {
      $req = "POST /atom/$bid HTTP/1.1\r\n"
           . "Authorization: Basic " . userpass() . "\r\n"
           . "Content-type: application/atom+xml\r\n"
           . "Content-length: " . strlen($entry) . "\r\n"
           . "UserAgent: self\r\n"
           . "Host: www.blogger.com\r\n"
           . "Connection: Close\r\n\r\n"
           . $entry;
      return Blogger::sendRequest($req, "200");
   }
   function removeEntry($bid, $eid) {
      $req  = "DELETE /atom/$bid/$eid HTTP/1.1\r\n"
            . "Authorization: Basic " . userpass() . "\r\n"
            . "UserAgent: self\r\n"
            . "Host: www.blogger.com\r\n\r\n"; 
      return Blogger::sendRequest($req, "204");
   }
   function replaceEntry($bid, $eid, $newentry) {
      $req  = "PUT /atom/$bid/$eid HTTP/1.1\r\n"
            . "Authorization: Basic " . userpass() . "\r\n"
            . "Content-type: application/atom+xml\r\n"
            . "Content-length: " . strlen($newentry) . "\r\n"
            . "UserAgent: self\r\n"
            . "Host: www.blogger.com\r\n\r\n"
            . $newentry;
      return Blogger::sendRequest($req, "200");
   }
}
?>
