/*	This work is licensed under Creative Commons GNU LGPL License.

	License: http://creativecommons.org/licenses/LGPL/2.1/

   Version: 1.0

	Author:  Stefan Goessner/2004-06
	Web:     http://goessner.net/ 
*/
var Http = {
   get: function(uri, callback, onrequest, onresponse) {
      try {
         var http = Http.createInstance();
         http.onreadystatechange = function() {
            if (http.readyState == 4 && http.status == 200 && callback) {
               callback(http.responseText);
               if (onresponse) onresponse();
            }
            return true;
         };
         if (onrequest) onrequest();
         http.open("GET", uri, true);
         http.send(null);
      }
      catch(e) {
         window.alert("Http.get: " + e.toString());
      }
      return false;
   },
   post: function(string, uri, callback, onrequest, onresponse) {
      try {
         var http = Http.createInstance();
         http.onreadystatechange = function() {
            if (http.readyState == 4 && http.status == 200 && callback) {
               callback(http.responseText);
               if (onresponse) onresponse();
            }
         };
         if (onrequest) onrequest();
         http.open("POST", uri, true);
         http.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;"); // for php variable $_post to work ..
         http.setRequestHeader("Content-Length", string.length);
         http.send(string);
      }
      catch(e) {
         window.alert("Http.post: " + e.toString());
      }
      return false;
   },
   put: function(string, uri, callback) {
      try {
         var http = Http.createInstance();
         http.onreadystatechange = function() {
            if (http.readyState == 4 && http.status == 200 && callback)
               callback(http.responseText);
         };
         http.open("PUT", uri, true);
         http.send(string);
      }
      catch(e) {
         window.alert("Http.get: " + e.toString());
      }
      return false;
   },
   del: function(uri, callback) {
      try {
         var http = Http.createInstance();
         http.onreadystatechange = function() {
            if (http.readyState == 4 && http.status == 200 && callback)
               callback(http.responseText);
         };
         http.open("DELETE", uri, true);
         Http.startRequest();
         http.send(null);
      }
      catch(e) {
         window.alert("Http.get: " + e.toString());
      }
      return false;
   },
   createInstance: function() {
      var o = null;
      if (!!window.XMLHttpRequest) {
         try { o = new XMLHttpRequest(); } catch (e) { o = null; }
      }
      else if (!!window.ActiveXObject) {
         try {o = new ActiveXObject("Msxml2.XMLHTTP.4.0"); } catch (e) { 
            try {o = new ActiveXObject("Msxml2.XMLHTTP.3.0"); } catch (e) { 
               try {o = new ActiveXObject("Msxml2.XMLHTTP"); } catch (e) { 
                  try { o = new ActiveXObject("Microsoft.XMLHTTP"); } catch (e) { 
                     try { o = new ActiveXObject("MSXML.XMLHTTP"); } catch (e) { 
                        try { o = new ActiveXObject("MSXML3.XMLHTTP"); } catch (e) { o = null; }
                     }
                  }
               }
            }
         }
      }
      return o;
   }
};
